//+------------------------------------------------------------------+
//|                                 NonLagMA_v5 Indicator Window.mq4 |
//|                                Copyright  2006, TrendLaboratory |
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |
//|                                   E-mail: igorad2003@yahoo.co.uk |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, TrendLaboratory"
#property link      "http://finance.groups.yahoo.com/group/TrendLaboratory"


#property indicator_separate_window
#property indicator_buffers 3
#property indicator_color1 Aqua
#property indicator_width1 2
#property indicator_color2 DarkViolet
#property indicator_width2 2
#property indicator_color3 Yellow
#property indicator_width3 2
#property indicator_maximum 2
#property indicator_minimum 0
//---- input parameters
extern int     Price          = 0;
extern int     Length         = 9;
extern int     Filter         = 5;
extern double  IndicatorValue = 1;

//---- indicator buffers
double Signal[];
double UpBuffer[];
double DnBuffer[];
double MABuffer[];
double trend[];


double alfa[];
int i, Phase, Len, Cycle=4;
double Coeff, beta, t, Sum, Weight, g;
double pi = 3.1415926535;    

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
  int init()
  {
   IndicatorBuffers(5);
   SetIndexStyle(0,DRAW_ARROW);
   SetIndexBuffer(0,Signal);
   SetIndexArrow(0,167);
   
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexBuffer(1,UpBuffer);
   SetIndexArrow(1,167);
   
   
   SetIndexStyle(2,DRAW_ARROW);
   SetIndexBuffer(2,DnBuffer);
   SetIndexArrow(2,167);
   
   SetIndexBuffer(3,MABuffer);
   SetIndexBuffer(4,trend);
    
   string short_name;
//---- indicator line
   
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS));
//---- name for DataWindow and indicator subwindow label
   short_name="NonLagMA Window("+Length+")";
   IndicatorShortName(short_name);
   SetIndexLabel(0,"Signal");
   SetIndexLabel(1,"Up");
   SetIndexLabel(2,"Dn");
//----
   SetIndexDrawBegin(0,Length*Cycle+Length);
   SetIndexDrawBegin(1,Length*Cycle+Length);
   SetIndexDrawBegin(2,Length*Cycle+Length);
//----
   
   Coeff =  3*pi;
   Phase = Length-1;
   Len = Length*Cycle + Phase;  
   ArrayResize(alfa,Len);
   Weight=0;    
      
      for (i=0;i<Len-1;i++)
      {
      if (i<=Phase-1) t = 1.0*i/(Phase-1);
      else t = 1.0 + (i-Phase+1)*(2.0*Cycle-1.0)/(Cycle*Length-1.0); 
      beta = MathCos(pi*t);
      g = 1.0/(Coeff*t+1);   
      if (t <= 0.5 ) g = 1;
      alfa[i] = g * beta;
      Weight += alfa[i];
      }
 
   return(0);
  }

//+------------------------------------------------------------------+
//| NonLagMA_v5                                                      |
//+------------------------------------------------------------------+
int start()
{
   int    i,shift, counted_bars=IndicatorCounted(),limit;
   double price;      
   if ( counted_bars > 0 )  limit=Bars-counted_bars;
   if ( counted_bars < 0 )  return(0);
   if ( counted_bars ==0 )  limit=Bars-Len-1; 
   if ( counted_bars < 1 ) 
   
   for(i=1;i<Length*Cycle+Length;i++) 
   {
   Signal[Bars-i]=IndicatorValue;    
   UpBuffer[Bars-i]=IndicatorValue;  
   DnBuffer[Bars-i]=IndicatorValue;  
   }
   
   for(shift=limit;shift>=0;shift--) 
   {	
      Sum = 0;
      for (i=0;i<=Len-1;i++)
	   { 
      if (Price == PRICE_CLOSE ) price = Close[shift+i];
      else if (Price == PRICE_OPEN ) price = Open[shift+i];
      else if (Price == PRICE_HIGH ) price = High[shift+i];
      else if (Price == PRICE_LOW ) price = Low[shift+i];
      else if (Price == PRICE_MEDIAN) price = 0.5*(High[shift+i]+Low[shift+i]);
      else if (Price == PRICE_TYPICAL) price = (High[shift+i]+Low[shift+i]+Close[shift+i])/3.0;
      else if (Price == PRICE_WEIGHTED) price = (High[shift+i]+Low[shift+i]+2*Close[shift+i])/4.0;
      Sum += alfa[i]*price;
      
      }
   
	if (Weight > 0) MABuffer[shift] = Sum/Weight;
   
      if (Filter>0)
      {
      if( MathAbs(MABuffer[shift]-MABuffer[shift+1]) < Filter*Point ) MABuffer[shift]=MABuffer[shift+1];
      }
      
   trend[shift]=trend[shift+1];
   if (MABuffer[shift]-MABuffer[shift+1] > Filter*Point) trend[shift]= 1; 
   if (MABuffer[shift+1]-MABuffer[shift] > Filter*Point) trend[shift]=-1; 
      
      if (trend[shift]>0)
      {  
         if (trend[shift+1]<0) 
         {
         Signal[shift]=IndicatorValue; 
         UpBuffer[shift] = EMPTY_VALUE;
         }
         else 
         {
         Signal[shift]=EMPTY_VALUE;
         UpBuffer[shift] = IndicatorValue;
         }
      DnBuffer[shift] = EMPTY_VALUE;
      }
      if (trend[shift]<0) 
      {
      
         if (trend[shift+1]>0) 
         { 
         Signal[shift]=IndicatorValue;
         DnBuffer[shift] = EMPTY_VALUE;
         }
         else 
         {
         Signal[shift]=EMPTY_VALUE;
         DnBuffer[shift] = IndicatorValue;
         }
      
      UpBuffer[shift] = EMPTY_VALUE;
      }
   }
   
	return(0);	
}

